---
title: Terraform v5.7.0 now available · Changelog
description: Terraform v5.7.0 fixes a number of known bugs in the v5 Provider
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-07-11-terraform-v570-provider/
  md: https://developers.cloudflare.com/changelog/2025-07-11-terraform-v570-provider/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Terraform v5.7.0 now available

Jul 14, 2025

[Cloudflare Fundamentals](https://developers.cloudflare.com/fundamentals/)

Earlier this year, we announced the launch of the new [Terraform v5 Provider](https://developers.cloudflare.com/changelog/2025-02-03-terraform-v5-provider/). We are aware of the high mumber of [issues](https://github.com/cloudflare/terraform-provider-cloudflare) reported by the Cloudflare community related to the v5 release, with 13.5% of resources impacted. We have committed to releasing improvements on a 2 week cadeance to ensure it's stability and relability, including the v5.7 release.

Thank you for continuing to raise issues and please keep an eye on this changelog for more information about upcoming releases.

#### Changes

* Addressed permanent diff bug on Cloudflare Tunnel config
* State is now saved correctly for Zero Trust Access applications
* Exact match is now working as expected within `data.cloudflare_zero_trust_access_applications`
* `cloudflare_zero_trust_access_policy` now supports OIDC claims & diff issues resolved
* Self hosted applications with private IPs no longer require a public domain for `cloudflare_zero_trust_access_application`.
* New resource:
  * `cloudflare_zero_trust_tunnel_warp_connector`
* Other bug fixes

For a more detailed look at all of the changes, see the [changelog](https://github.com/cloudflare/terraform-provider-cloudflare/releases/tag/v5.7.0) in GitHub.

#### Issues Closed

* [#5563: cloudflare\_logpull\_retention is missing import](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5563)
* [#5608: cloudflare\_zero\_trust\_access\_policy in 5.5.0 provider gives error upon apply unexpected new value: .app\_count: was cty.NumberIntVal(0), but now cty.NumberIntVal(1)](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5608)
* [#5612: data.cloudflare\_zero\_trust\_access\_applications does not exact match](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5612)
* [#5532: cloudflare\_zero\_trust\_access\_identity\_provider detects changes on every plan](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5532)
* [#5662: cloudflare\_zero\_trust\_access\_policy does not support OIDC claims](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5662)
* [#5565: Running Terraform with the cloudflare\_zero\_trust\_access\_policy resource results in updates on every apply, even when no changes are made - breaks idempotency](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5565)
* [#5529: cloudflare\_zero\_trust\_access\_application: self hosted applications with private ips require public domain](https://github.com/cloudflare/terraform-provider-cloudflare/issues/5529)

If you have an unaddressed issue with the provider, we encourage you to check the [open issues](https://github.com/cloudflare/terraform-provider-cloudflare/issues) and open a new one if one does not already exist for what you are experiencing.

#### Upgrading

We suggest holding on migration to v5 while we work on stablization of the v5 provider. This will ensure Cloudflare can work ahead and avoid any blocking issues.

If you'd like more information on migrating from v4 to v5, please make use of the [migration guide](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/guides/version-5-upgrade). We have provided automated migration scripts using Grit which simplify the transition, although these do not support implementations which use Terraform modules, so customers making use of modules need to migrate manually. Please make use of `terraform plan` to test your changes before applying, and let us know if you encounter any additional issues by reporting to our [GitHub repository](https://github.com/cloudflare/terraform-provider-cloudflare).

#### For more info

* [Terraform provider](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs)
* [Documentation on using Terraform with Cloudflare](https://developers.cloudflare.com/terraform/)
