---
title: Configure Workers for Platforms · Cloudflare for Platforms docs
description: To enable Workers for Platforms, you will need to purchase the
  Workers for Platforms Paid plan.
lastUpdated: 2025-09-15T15:28:43.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/get-started/configuration/
  md: https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/get-started/configuration/index.md
---

## Prerequisites:

### Enable Workers for Platforms

To enable Workers for Platforms, you will need to purchase the [Workers for Platforms Paid plan](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/platform/pricing/).

1. In the Cloudflare dashboard, go to the **Workers for Platforms** page and select your account.

   [Go to **Workers for Platforms**](https://dash.cloudflare.com/?to=/:account/workers-for-platforms)

2. Complete the payment process for the Workers for Platforms Paid plan.

If you are an Enterprise customer, contact your Cloudflare account team to enable Workers for Platforms.

### Learn about Workers for Platforms

Refer to [How Workers for Platforms works](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/reference/how-workers-for-platforms-works/) to learn more about Workers for Platforms terminology and architecture.

***

This guide will instruct you on setting up Workers for Platforms. You will configure a [dispatch namespace](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/reference/how-workers-for-platforms-works/#dispatch-namespace), a [dynamic dispatch Worker](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/reference/how-workers-for-platforms-works/#dynamic-dispatch-worker) and a [user Worker](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/reference/how-workers-for-platforms-works/#user-workers) to test a request end to end.

### 1. Create a user Worker

First, create a [user Worker](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/reference/how-workers-for-platforms-works/#user-workers). User Workers are Workers that your end users (end developers) will be uploading.

User Workers can be created using C3. C3 (create-cloudflare-cli) is a command-line tool designed to help you setup and deploy Workers to Cloudflare as fast as possible.

Open a terminal window and run C3 to create your Worker project. This example creates a user Worker called `customer-worker-1`.

```sh
npm create cloudflare@latest customer-worker-1 -- --type=hello-world
```

When following the interactive prompts, answer the questions as below:

* Select `no` to using TypeScript.
* **Select `no` to deploying your application.**

### 2. Create a dispatch namespace

Create a [dispatch namespace](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/reference/how-workers-for-platforms-works/#dispatch-namespace). A dispatch namespace is made up of a collection of [user Workers](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/reference/how-workers-for-platforms-works/#user-workers).

This example creates a dispatch namespace called `testing`. To create a dispatch namespace, run:

```sh
npx wrangler dispatch-namespace create testing
```

### 3. Upload a user Worker to the dispatch namespace

Make sure you are in your user Worker's project directory:

```sh
cd customer-worker-1
```

To upload and deploy the user Worker to the dispatch namespace, running the following command:

```sh
npx wrangler deploy --dispatch-namespace testing
```

### 4. Create a dynamic dispatch Worker

A [dynamic dispatch Worker](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/reference/how-workers-for-platforms-works/#dynamic-dispatch-worker) is a specialized routing Worker that directs incoming requests to the appropriate user Workers in your dispatch namespace. Instead of using [Workers Routes](https://developers.cloudflare.com/workers/configuration/routing/routes/), dispatch Workers let you programmatically control request routing through code.

#### Why use a dynamic dispatch Worker?

* **Scale**: Perfect for routing thousands or millions of hostnames to different Workers, without needing to rely on [Workers Routes](https://developers.cloudflare.com/workers/configuration/routing/routes/)

* **Custom routing logic**: Write code to determine exactly how requests should be routed. For example:

  * Map hostnames directly to specific Workers
  * Route requests based on subdomains
  * Use request metadata or headers for routing decisions

* **Add platform functionality**: Build in additional features at the routing layer.

  * Run authentication checks before requests reach user Workers
  * Sanitize incoming requests
  * Attach useful context like user IDs or account information
  * Transform requests or responses as needed

**To create your dynamic dispatch Worker:**

Navigate up a level from your user Worker's project directory:

```sh
cd ..
```

Create your dynamic dispatch Worker. In this example, the dispatch Worker is called `my-dispatcher`.

* npm

  ```sh
  npm create cloudflare@latest -- my-dispatcher
  ```

* yarn

  ```sh
  yarn create cloudflare my-dispatcher
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest my-dispatcher
  ```

For setup, select the following options:

* For *What would you like to start with?*, choose `Hello World example`.
* For *Which template would you like to use?*, choose `Worker only`.
* For *Which language do you want to use?*, choose `JavaScript`.
* For *Do you want to use git for version control?*, choose `Yes`.
* For *Do you want to deploy your application?*, choose `No` (we will be making some changes before deploying).

Change to your project's directory:

```sh
cd my-dispatcher
```

Open the Wrangler file in your project directory, and add the dispatch namespace binding:

* wrangler.jsonc

  ```jsonc
  {
    "$schema": "./node_modules/wrangler/config-schema.json",
    "dispatch_namespaces": [
      {
        "binding": "DISPATCHER",
        "namespace": "testing"
      }
    ]
  }
  ```

* wrangler.toml

  ```toml
  [[dispatch_namespaces]]
  binding = "DISPATCHER"
  namespace = "testing"
  ```

Add the following to the index.js file:

```js
export default {
  async fetch(req, env) {
    const worker = env.DISPATCHER.get("customer-worker-1");
    return await worker.fetch(req);
  },
};
```

This example shows a simple dynamic dispatch Worker that routes all requests to a single user Worker. For more advanced routing patterns, you could route based on hostname, path, custom metadata, or other request properties.

Deploy your dynamic dispatch Worker:

```sh
npx wrangler deploy
```

### 5. Test a request

You will now send a request to the route your dynamic dispatch Worker is on. You should receive the response (`Hello world`) you created in your user Worker (`customer-worker-1`) that you call from your dynamic dispatch Worker (`my-dispatcher`).

Preview the response to your Workers for Platforms project at `https://my-dispatcher.<YOUR_WORKER_SUBDOMAIN>.workers.dev/`.

By completing this guide, you have successfully set up a dispatch namespace, dynamic dispatch Worker and user Worker to test a request end to end.

## Related resources

* [Workers for Platforms example project](https://github.com/cloudflare/workers-for-platforms-example) - An end to end example project using Workers for Platforms
