---
title: Compound words · Cloudflare Style Guide
description: "Whitespace is used in our blog posts and product content. For the
  sake of consistency, follow these conventions when using them:"
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/grammar/parts-of-speech/compound-words/
  md: https://developers.cloudflare.com/style-guide/grammar/parts-of-speech/compound-words/index.md
---

## Whitespace

Whitespace is used in our blog posts and product content. For the sake of consistency, follow these conventions when using them:

| ✅ | ❌ | Example |
| - | - | - |
| nameserver | name servers | Change your nameservers to Cloudflare's. |
| hostname | host name | Add a \*. SAN (wildcard) to the custom hostname certificate. |
| data center | datacenter | Cloudflare updates the new setting across all of our data centers around the world. |
| checkbox | check box | Select the Transfer lock checkbox before continuing the setup. |

When using compound words that have a preposition in them (think log in, or set up), they should be written as two separate words when they are verbs, and as one word when they are nouns.

See these examples:

### Verbs

Now you can **set up** Centrify, OneLogin, and other identity providers with Cloudflare Access.

Learn how to start using SSO to **log in** to the Cloudflare dashboard.

Make sure to **back up** your data.

### Nouns

Having DAGs that can run simultaneously requires an Airflow **setup** that has been built and configured to scale.

Share an account without sharing a **login**.

This allows you to restore your data from the **backup**.

## Hyphenation

Certain expressions should be hyphenated depending on their position and role in the sentence.

As a general rule, when a compound word precedes a noun, it is called a **modifier** and should be hyphenated. When the same word comes after a verb, it has the role of an adverb and it should not be hyphenated.

Examples:

| Modifiers | Adverbs |
| - | - |
| Keep **up-to-date** passwords secured and safe. | Keep passwords safe by staying **up to date** |
| **Day-to-day** maintenance means any daily processes which must be implemented for the equipment. | The duration of a maintenance session will vary from **day to day**. |
| This allows us to implement **state-of-the-art** security for our customers. | This approach to authentication was the **state of the art** until a couple years ago. |
